<?php
require_once("fpdf/fpdf.php");

class PDF_Code128nc extends FPDF {

protected $T128;                                         // Tableau des codes 128
protected $ABCset = "";                                  // jeu des caractères éligibles au C128
protected $Aset = "";                                    // Set A du jeu des caractères éligibles
protected $Bset = "";                                    // Set B du jeu des caractères éligibles
protected $Cset = "";                                    // Set C du jeu des caractères éligibles
protected $SetFrom;                                      // Convertisseur source des jeux vers le tableau
protected $SetTo;                                        // Convertisseur destination des jeux vers le tableau
protected $JStart = array("A"=>103, "B"=>104, "C"=>105); // Caractères de sélection de jeu au début du C128
protected $JSwap = array("A"=>101, "B"=>100, "C"=>99);   // Caractères de changement de jeu

//____________________________ Extension du constructeur _______________________
function __construct($orientation='P', $unit='mm', $format='A4') {

    parent::__construct($orientation,$unit,$format);

    $this->T128[] = array(2, 1, 2, 2, 2, 2);           //0 : [ ]               // composition des caractères
    $this->T128[] = array(2, 2, 2, 1, 2, 2);           //1 : [!]
    $this->T128[] = array(2, 2, 2, 2, 2, 1);           //2 : ["]
    $this->T128[] = array(1, 2, 1, 2, 2, 3);           //3 : [#]
    $this->T128[] = array(1, 2, 1, 3, 2, 2);           //4 : [$]
    $this->T128[] = array(1, 3, 1, 2, 2, 2);           //5 : [%]
    $this->T128[] = array(1, 2, 2, 2, 1, 3);           //6 : [&]
    $this->T128[] = array(1, 2, 2, 3, 1, 2);           //7 : [']
    $this->T128[] = array(1, 3, 2, 2, 1, 2);           //8 : [(]
    $this->T128[] = array(2, 2, 1, 2, 1, 3);           //9 : [)]
    $this->T128[] = array(2, 2, 1, 3, 1, 2);           //10 : [*]
    $this->T128[] = array(2, 3, 1, 2, 1, 2);           //11 : [+]
    $this->T128[] = array(1, 1, 2, 2, 3, 2);           //12 : [,]
    $this->T128[] = array(1, 2, 2, 1, 3, 2);           //13 : [-]
    $this->T128[] = array(1, 2, 2, 2, 3, 1);           //14 : [.]
    $this->T128[] = array(1, 1, 3, 2, 2, 2);           //15 : [/]
    $this->T128[] = array(1, 2, 3, 1, 2, 2);           //16 : [0]
    $this->T128[] = array(1, 2, 3, 2, 2, 1);           //17 : [1]
    $this->T128[] = array(2, 2, 3, 2, 1, 1);           //18 : [2]
    $this->T128[] = array(2, 2, 1, 1, 3, 2);           //19 : [3]
    $this->T128[] = array(2, 2, 1, 2, 3, 1);           //20 : [4]
    $this->T128[] = array(2, 1, 3, 2, 1, 2);           //21 : [5]
    $this->T128[] = array(2, 2, 3, 1, 1, 2);           //22 : [6]
    $this->T128[] = array(3, 1, 2, 1, 3, 1);           //23 : [7]
    $this->T128[] = array(3, 1, 1, 2, 2, 2);           //24 : [8]
    $this->T128[] = array(3, 2, 1, 1, 2, 2);           //25 : [9]
    $this->T128[] = array(3, 2, 1, 2, 2, 1);           //26 : [:]
    $this->T128[] = array(3, 1, 2, 2, 1, 2);           //27 : [;]
    $this->T128[] = array(3, 2, 2, 1, 1, 2);           //28 : [<]
    $this->T128[] = array(3, 2, 2, 2, 1, 1);           //29 : [=]
    $this->T128[] = array(2, 1, 2, 1, 2, 3);           //30 : [>]
    $this->T128[] = array(2, 1, 2, 3, 2, 1);           //31 : [?]
    $this->T128[] = array(2, 3, 2, 1, 2, 1);           //32 : [@]
    $this->T128[] = array(1, 1, 1, 3, 2, 3);           //33 : [A]
    $this->T128[] = array(1, 3, 1, 1, 2, 3);           //34 : [B]
    $this->T128[] = array(1, 3, 1, 3, 2, 1);           //35 : [C]
    $this->T128[] = array(1, 1, 2, 3, 1, 3);           //36 : [D]
    $this->T128[] = array(1, 3, 2, 1, 1, 3);           //37 : [E]
    $this->T128[] = array(1, 3, 2, 3, 1, 1);           //38 : [F]
    $this->T128[] = array(2, 1, 1, 3, 1, 3);           //39 : [G]
    $this->T128[] = array(2, 3, 1, 1, 1, 3);           //40 : [H]
    $this->T128[] = array(2, 3, 1, 3, 1, 1);           //41 : [I]
    $this->T128[] = array(1, 1, 2, 1, 3, 3);           //42 : [J]
    $this->T128[] = array(1, 1, 2, 3, 3, 1);           //43 : [K]
    $this->T128[] = array(1, 3, 2, 1, 3, 1);           //44 : [L]
    $this->T128[] = array(1, 1, 3, 1, 2, 3);           //45 : [M]
    $this->T128[] = array(1, 1, 3, 3, 2, 1);           //46 : [N]
    $this->T128[] = array(1, 3, 3, 1, 2, 1);           //47 : [O]
    $this->T128[] = array(3, 1, 3, 1, 2, 1);           //48 : [P]
    $this->T128[] = array(2, 1, 1, 3, 3, 1);           //49 : [Q]
    $this->T128[] = array(2, 3, 1, 1, 3, 1);           //50 : [R]
    $this->T128[] = array(2, 1, 3, 1, 1, 3);           //51 : [S]
    $this->T128[] = array(2, 1, 3, 3, 1, 1);           //52 : [T]
    $this->T128[] = array(2, 1, 3, 1, 3, 1);           //53 : [U]
    $this->T128[] = array(3, 1, 1, 1, 2, 3);           //54 : [V]
    $this->T128[] = array(3, 1, 1, 3, 2, 1);           //55 : [W]
    $this->T128[] = array(3, 3, 1, 1, 2, 1);           //56 : [X]
    $this->T128[] = array(3, 1, 2, 1, 1, 3);           //57 : [Y]
    $this->T128[] = array(3, 1, 2, 3, 1, 1);           //58 : [Z]
    $this->T128[] = array(3, 3, 2, 1, 1, 1);           //59 : [[]
    $this->T128[] = array(3, 1, 4, 1, 1, 1);           //60 : [\]
    $this->T128[] = array(2, 2, 1, 4, 1, 1);           //61 : []]
    $this->T128[] = array(4, 3, 1, 1, 1, 1);           //62 : [^]
    $this->T128[] = array(1, 1, 1, 2, 2, 4);           //63 : [_]
    $this->T128[] = array(1, 1, 1, 4, 2, 2);           //64 : [`]
    $this->T128[] = array(1, 2, 1, 1, 2, 4);           //65 : [a]
    $this->T128[] = array(1, 2, 1, 4, 2, 1);           //66 : [b]
    $this->T128[] = array(1, 4, 1, 1, 2, 2);           //67 : [c]
    $this->T128[] = array(1, 4, 1, 2, 2, 1);           //68 : [d]
    $this->T128[] = array(1, 1, 2, 2, 1, 4);           //69 : [e]
    $this->T128[] = array(1, 1, 2, 4, 1, 2);           //70 : [f]
    $this->T128[] = array(1, 2, 2, 1, 1, 4);           //71 : [g]
    $this->T128[] = array(1, 2, 2, 4, 1, 1);           //72 : [h]
    $this->T128[] = array(1, 4, 2, 1, 1, 2);           //73 : [i]
    $this->T128[] = array(1, 4, 2, 2, 1, 1);           //74 : [j]
    $this->T128[] = array(2, 4, 1, 2, 1, 1);           //75 : [k]
    $this->T128[] = array(2, 2, 1, 1, 1, 4);           //76 : [l]
    $this->T128[] = array(4, 1, 3, 1, 1, 1);           //77 : [m]
    $this->T128[] = array(2, 4, 1, 1, 1, 2);           //78 : [n]
    $this->T128[] = array(1, 3, 4, 1, 1, 1);           //79 : [o]
    $this->T128[] = array(1, 1, 1, 2, 4, 2);           //80 : [p]
    $this->T128[] = array(1, 2, 1, 1, 4, 2);           //81 : [q]
    $this->T128[] = array(1, 2, 1, 2, 4, 1);           //82 : [r]
    $this->T128[] = array(1, 1, 4, 2, 1, 2);           //83 : [s]
    $this->T128[] = array(1, 2, 4, 1, 1, 2);           //84 : [t]
    $this->T128[] = array(1, 2, 4, 2, 1, 1);           //85 : [u]
    $this->T128[] = array(4, 1, 1, 2, 1, 2);           //86 : [v]
    $this->T128[] = array(4, 2, 1, 1, 1, 2);           //87 : [w]
    $this->T128[] = array(4, 2, 1, 2, 1, 1);           //88 : [x]
    $this->T128[] = array(2, 1, 2, 1, 4, 1);           //89 : [y]
    $this->T128[] = array(2, 1, 4, 1, 2, 1);           //90 : [z]
    $this->T128[] = array(4, 1, 2, 1, 2, 1);           //91 : [{]
    $this->T128[] = array(1, 1, 1, 1, 4, 3);           //92 : [|]
    $this->T128[] = array(1, 1, 1, 3, 4, 1);           //93 : [}]
    $this->T128[] = array(1, 3, 1, 1, 4, 1);           //94 : [~]
    $this->T128[] = array(1, 1, 4, 1, 1, 3);           //95 : [DEL]
    $this->T128[] = array(1, 1, 4, 3, 1, 1);           //96 : [FNC3]
    $this->T128[] = array(4, 1, 1, 1, 1, 3);           //97 : [FNC2]
    $this->T128[] = array(4, 1, 1, 3, 1, 1);           //98 : [SHIFT]
    $this->T128[] = array(1, 1, 3, 1, 4, 1);           //99 : [Cswap]
    $this->T128[] = array(1, 1, 4, 1, 3, 1);           //100 : [Bswap]                
    $this->T128[] = array(3, 1, 1, 1, 4, 1);           //101 : [Aswap]
    $this->T128[] = array(4, 1, 1, 1, 3, 1);           //102 : [FNC1]
    $this->T128[] = array(2, 1, 1, 4, 1, 2);           //103 : [Astart]
    $this->T128[] = array(2, 1, 1, 2, 1, 4);           //104 : [Bstart]
    $this->T128[] = array(2, 1, 1, 2, 3, 2);           //105 : [Cstart]
    $this->T128[] = array(2, 3, 3, 1, 1, 1);           //106 : [STOP]
    $this->T128[] = array(2, 1);                       //107 : [END BAR]

    for ($i = 32; $i <= 95; $i++) {                                            // jeux de caractères
        $this->ABCset .= chr($i);
    }
    $this->Aset = $this->ABCset;
    $this->Bset = $this->ABCset;
    
    for ($i = 0; $i <= 31; $i++) {
        $this->ABCset .= chr($i);
        $this->Aset .= chr($i);
    }
    for ($i = 96; $i <= 127; $i++) {
        $this->ABCset .= chr($i);
        $this->Bset .= chr($i);
    }
    for ($i = 200; $i <= 210; $i++) {                                           // controle 128
        $this->ABCset .= chr($i);
        $this->Aset .= chr($i);
        $this->Bset .= chr($i);
    }
    $this->Cset="0123456789".chr(206);

    for ($i=0; $i<96; $i++) {                                                   // convertisseurs des jeux A & B
        @$this->SetFrom["A"] .= chr($i);
        @$this->SetFrom["B"] .= chr($i + 32);
        @$this->SetTo["A"] .= chr(($i < 32) ? $i+64 : $i-32);
        @$this->SetTo["B"] .= chr($i);
    }
    for ($i=96; $i<107; $i++) {                                                 // contrôle des jeux A & B
        @$this->SetFrom["A"] .= chr($i + 104);
        @$this->SetFrom["B"] .= chr($i + 104);
        @$this->SetTo["A"] .= chr($i);
        @$this->SetTo["B"] .= chr($i);
    }
}

//________________ Fonction encodage et dessin du code 128 _____________________
function Code128($x, $y, $code, $w, $h) {
    $Aguid = "";                                                                      // Création des guides de choix ABC
    $Bguid = "";
    $Cguid = "";
    for ($i=0; $i < strlen($code); $i++) {
        $needle = substr($code,$i,1);
        $Aguid .= ((strpos($this->Aset,$needle)===false) ? "N" : "O"); 
        $Bguid .= ((strpos($this->Bset,$needle)===false) ? "N" : "O"); 
        $Cguid .= ((strpos($this->Cset,$needle)===false) ? "N" : "O");
    }

    $SminiC = "OOOO";
    $IminiC = 4;

    $crypt = "";
    while ($code > "") {
                                                                                    // BOUCLE PRINCIPALE DE CODAGE
        $i = strpos($Cguid,$SminiC);                                                // forçage du jeu C, si possible
        if ($i!==false) {
            $Aguid [$i] = "N";
            $Bguid [$i] = "N";
        }

        if (substr($Cguid,0,$IminiC) == $SminiC) {                                  // jeu C
            $crypt .= chr(($crypt > "") ? $this->JSwap["C"] : $this->JStart["C"]);  // début Cstart, sinon Cswap
            $made = strpos($Cguid,"N");                                             // étendu du set C
            if ($made === false) {
                $made = strlen($Cguid);
            }
            if (fmod($made,2)==1) {
                $made--;                                                            // seulement un nombre pair
            }
            for ($i=0; $i < $made; $i += 2) {
                $crypt .= chr(strval(substr($code,$i,2)));                          // conversion 2 par 2
            }
            $jeu = "C";
        } else {
            $madeA = strpos($Aguid,"N");                                            // étendu du set A
            if ($madeA === false) {
                $madeA = strlen($Aguid);
            }
            $madeB = strpos($Bguid,"N");                                            // étendu du set B
            if ($madeB === false) {
                $madeB = strlen($Bguid);
            }
            $made = (($madeA < $madeB) ? $madeB : $madeA );                         // étendu traitée
            $jeu = (($madeA < $madeB) ? "B" : "A" );                                // Jeu en cours

            $crypt .= chr(($crypt > "") ? $this->JSwap[$jeu] : $this->JStart[$jeu]); // début start, sinon swap

            $crypt .= strtr(substr($code, 0,$made), $this->SetFrom[$jeu], $this->SetTo[$jeu]); // conversion selon jeu

        }
        $code = substr($code,$made);                                           // raccourcir légende et guides de la zone traitée
        $Aguid = substr($Aguid,$made);
        $Bguid = substr($Bguid,$made);
        $Cguid = substr($Cguid,$made);
    }                                                                          // FIN BOUCLE PRINCIPALE

    $check = ord($crypt[0]);                                                   // calcul de la somme de contrôle
    for ($i=0; $i<strlen($crypt); $i++) {
        $check += (ord($crypt[$i]) * $i);
    }
    $check %= 103;

    $crypt .= chr($check) . chr(106) . chr(107);                               // Chaine cryptée complète

    $i = (strlen($crypt) * 11) - 8;                                            // calcul de la largeur du module
    $modul = $w/$i;

    for ($i=0; $i<strlen($crypt); $i++) {                                      // BOUCLE D'IMPRESSION
        $c = $this->T128[ord($crypt[$i])];
        for ($j=0; $j<count($c); $j++) {
            $this->Rect($x,$y,$c[$j]*$modul,$h,"F");
            $x += ($c[$j++]+$c[$j])*$modul;
        }
    }
  }
	protected $B = 0;
	protected $I = 0;
	protected $U = 0;
	protected $HREF = '';
	function inicio($erazons,$enombrec,$eruc,$fnumeron,$edireccion,$ecespecial,$eocontab,$crazons,$cruc,$ffechac,$descta,$desctipoe,$clavep,$motivoanula,$valoranula,$fnumerof,$fechafact,$tipo,$dirsucursal,$mensaje5){
		//substr($nprove1,80)
	//$this->Ln();
	if ($tipo == 'NC'){
		$titulo = 'NOTA DE CREDITO';
	}	elseif ($tipo == 'ND'){
		$titulo = 'NOTA DE DEBITO';
	}
	$this->SetY(5);
	$this->SetFont('Arial','B',9);
	$this->Cell(100,30,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,10,'RUC '.$eruc,'TRL',1,'L'); //Titulo del reporte	
	$this->Cell(100,10,' ',0,0,'C'); //Titulo del reporte
	
	$this->Cell(1,5,'',0,0,'L');	
	$this->Cell(90,10,$titulo,'RL',1,'L');
	$this->Cell(100,10,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(10,10,'No','L',0,'L'); 
	$this->Cell(80,10,''.substr($fnumeron,0,3).'-'.substr($fnumeron,3,3).'-'.substr($fnumeron,6,9),'R',1,'C');
	$this->Cell(100,10,' ',0,0,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,10,'NUMERO AUTORIZACION','LR',1,'L'); 
	$this->Cell(100,10,' ',0,0,'C');
	$this->SetFont('Arial','',8);
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,10,$clavep,'LR',1,'L');
	$this->Cell(100,10,' ',0,0,'C'); 
	
	if ($eocontab== 'S'){
		$eocontab2= 'SI';
	} else {
		$eocontab2= 'NO';
	}
	
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',7);
	$this->Cell(20,10,'AMBIENTE','L',0,'L');
	$this->SetFont('Arial','',7); 
	$this->Cell(70,10,''.$descta,'R',1,'L');
	$this->Cell(100,10,' ',0,0,'C');
	//$this->Cell(90,10,'',0,1,'C');
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','B',7);
	$this->Cell(20,10,'EMISION','L',0,'L'); 
	$this->SetFont('Arial','',7);
	$this->Cell(70,10,''.$desctipoe,'R',1,'L');
	
	//$this->Cell(80,40,'',1,0,'L'); //Titulo del reporte
	$this->SetFont('Arial','B',7);
	$this->Cell(100,5,utf8_decode($erazons),'TRL',0,'L'); //Titulo del reporte
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,5,'   ','RL',1,'L');
	$this->SetFont('Arial','B',7);
	//$this->Cell(100,5,'Direccion Matriz:'.$edireccion,'RL',0,'L'); //Titulo del reporte
	$this->Cell(30,5,utf8_decode('Direccion Matriz: '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(70,5,utf8_decode(substr($edireccion,0,79)),'R',0,'L');
	$this->Cell(1,5,'',0,0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$nprove = '';
	$this->Cell(90,5,''.substr($nprove,0,79),'RL',1,'L'); //Ruc en la tabla Empresac
	$this->SetFont('Arial','B',7);
	//$this->Cell(100,5,'Direccion Sucursal: '.$edireccion,'RL',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','B',7);
	$this->Cell(30,5,utf8_decode('Direccion Sucursal: '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(70,5,utf8_decode($dirsucursal),'R',0,'L');
	//$this->Cell(15,7,'',0,0,'L'); //Titulo del reporte
	$this->Cell(1,5,'',0,0,'L');
	$nruc = '';
	$this->Cell(90,5,''.$nruc,'LR',1,'L'); //Titulo del reporte
	$this->SetFont('Arial','B',7);
	//$this->Cell(40,5,'Contribuyente Especial Nro:  ','L',0,'L'); //Titulo del reporte
	$this->Cell(40,5,'','L',0,'L'); //Titulo del reporte
	$this->Cell(40,5,'  ','L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	//$this->Cell(60,5,$ecespecial,'R',0,'L');
	$this->Cell(60,5,'','R',0,'L');
	$this->Cell(60,5,'','R',0,'L');
	//$this->Cell(15,7,'',0,0,'L'); //Titulo del reporte
	$this->Cell(1,5,'',0,0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(90,5,'CLAVE DE ACCESO','RL',1,'C');
	$this->SetFont('Arial','B',7);
	
	$this->Cell(40,5,'Obligado a llevar Contabilidad:  ','L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',7);
	$this->Cell(60,5,$eocontab2,'R',0,'L');
	//$this->Cell(15,7,'',0,0,'L'); 
	$this->Cell(1,5,'',0,0,'L');
	$this->code128(115,80,$clavep,80,10);
	$this->Cell(90,5,$clavep,'RL',1,'C'); //Titulo del reporte
	$this->Cell(100,5,$mensaje5,'LRB',0,'L'); //Agente Retencion
	$this->Cell(1,5,'',0,0,'L');
	$this->Cell(90,5,'','RLB',1,'L');
	$this->Cell(90,2,'',0,1,'L');
	// Datos Cliente
	$this->SetFont('Arial','',8);
	$this->SetXY(50,107);
	$y1 = $this->GetY();
	$x1 = $this->GetX();	
	$this->SetFillColor(255,255,255);
	if (strlen(trim($crazons)) >= 56){
		$this->Cell(100,5,''.utf8_decode(substr($crazons,0,55)),'T',0,'L');
		$slinea = 'T';
	}	else {
		$this->Cell(100,5,''.utf8_decode($crazons),'T',0,'L');
		$slinea = 'F';
	}	
	
	$y2 = $this->GetY();
	//$alto = $y2 - $y1 ;
	$alto = 5 ;
	$this->SetFont('Arial','B',9);
	$this->SetXY(150,107);
	$this->Cell(25,$alto,utf8_decode('Identificacion'),'T',0,'L');
	//$this->SetFont('Arial','B',9);
	$this->SetXY(10,107);
	$this->Cell(40,$alto,utf8_decode('Razon Social / Nombres: '),'TL',0,'L'); //Titulo del reporte
	$this->SetXY(175,107);
	$this->SetFont('Arial','',8);
	$this->Cell(26,$alto,''.$cruc,'TR',1,'L');
	if ($slinea == 'T'){
		$this->SetXY(10,112);
		$this->Cell(191,5,''.utf8_decode(substr($crazons,55,119)),'LR',1,'L');
	}	
	
	$this->SetFont('Arial','B',9);
	$this->Cell(40,5,utf8_decode('Fecha emision '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->Cell(100,5,''.$ffechac,'',0,'L');
	$this->SetFont('Arial','B',9);
	$this->Cell(20,5,'','',0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(31,5,'','R',1,'L');
	
	$this->Cell(10,5,'','L',0,'L');
	$this->Cell(170,5,'','B',0,'L');
	$this->Cell(11,5,'','R',1,'L');
	
	$coddoc = '01';
	if ($coddoc == '01'){
		$fact = 'FACTURA';
	}
	$numdoc2 = substr($fnumerof,0,3).'-'.substr($fnumerof,3,3).'-'.substr($fnumerof,6,14);
	$this->SetFont('Arial','B',9);
	$this->Cell(65,5,utf8_decode('Comprobante que se modifica '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->Cell(45,5,''.$fact,'',0,'L');
	$this->SetFont('Arial','',9);
	$this->Cell(40,5,$numdoc2,'',0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(41,5,'','R',1,'L');
	
	$this->SetFont('Arial','B',9);
	$this->Cell(65,5,utf8_decode('Fecha Emision Comprobante a modificar '),'L',0,'L'); //Titulo del reporte
	$this->SetFont('Arial','',8);
	$this->Cell(45,5,''.$fechafact,'',0,'L');
	$this->SetFont('Arial','',9);
	$this->Cell(40,5,'','',0,'L');
	$this->SetFont('Arial','',8);
	$this->Cell(41,5,'','R',1,'L');
	$motivoanula = "ANULA FACTURA";
	if ($tipo == 'NC'){
		$this->SetFont('Arial','B',9);
		$this->Cell(65,5,utf8_decode('Razon de modificacion '),'LB',0,'L'); //Titulo del reporte
		$this->SetFont('Arial','',8);
		$this->Cell(126,5,' '.utf8_decode($motivoanula),'RB',1,'L');
		$this->Cell(90,2,'',0,1,'L');
	}	elseif ($tipo == 'ND'){
			$this->SetFont('Arial','B',9);
			$this->Cell(65,5,utf8_decode(' '),'LB',0,'L'); //Titulo del reporte
			$this->SetFont('Arial','',8);
			$this->Cell(126,5,' ','RB',1,'L');
			$this->Cell(90,2,'',0,1,'L');
	}		
	//$this->Cell(41,5,'','R',1,'L');
}	
	
	function detalle($factid,$cn,$crazons,$codaltpro){
		$sql = "SELECT f.productoServicioId,f.NotaCreditoDetalleCantidad,f.NotaCreditoDetalleNombre,f.NotaCreditodetallepvp,f.Notacreditodetalledescuento,f.NotaCreditoDetalleBaseImponibl,f.NotaCreditoDetalletimpiva,f.NotaCreditoDetalleCodigo,f.NotaCreditoDetalleCodigoPorcen,f.NotaCreditoDetalleIva,p.ProductoServicioNombre,p.ProductoServicioNomGenerico,p.ProductoServicioReferencia,p.ProductoServicioDescripcion, f.descripcionalterna FROM notacreditodetalle f, productoservicio p WHERE f.NotaCreditoId = $factid and f.ProductoServicioId = p.productoservicioid";
    	if (!$resultado = $cn->query($sql)) {
            		
    		echo "Lo sentimos, problemas al buscar datos de detalle interno NC pdf.";
    		exit;
        }
        
			//Ahora mediante un bucle construimos el reporte 
			//Pero primero validemos si existen alumnos en ese curso nos cargue los datos
			//$numfilas = mysql_num_rows($listado);
			
			$varo = 0;
			if (strlen(trim($crazons)) >= 56){
				$ubicaf = 150;
			} else {
				$ubicaf = 145;
			}	
			while($fila = $resultado->fetch_assoc()){
			 $tline = 0;
			 $tline = 0;
			 $tline= round($tline,2);
			 //buscadescripciona alterna
			 $traedesc = traedescemp($cn);
			 if ($traedesc == 0){
				 $descdet= $fila['ProductoServicioNombre'];
			 } elseif ($traedesc == 1){
				 $descdet= $fila['descripcionalterna'];
			 }
			 $descadic = $fila['NotaCreditoDetalleNombre'];
			 $totdesc = utf8_decode($descdet).' '.utf8_decode($descadic);
			 $numcar = strlen($totdesc);
			 //echo 'numcar '.$numcar.'desc '.$totdesc;
			 //$alto = altofila($numcar);
			 $alto = 4;
			 $this->SetXY(45,$ubicaf);
			 $y1 = $this->GetY();
			 $x1 = $this->GetX(); 
			 $this->MultiCell(80,4,$totdesc,1,'l'); 
			 $y2 = $this->GetY();
	 		 $alto = $y2 - $y1 ;
			 $this->SetXY(10,$ubicaf);
			 if ($codaltpro == 0){
				$this->Cell(35,$alto,$fila['productoServicioId'],1,0);
			 } elseif ($codaltpro == 1){
				$this->Cell(35,$alto,$fila['ProductoServicioNomGenerico'],1,0);
			 } 
			 //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
			 $this->SetXY(125,$ubicaf);
			 $this->Cell(15,$alto,$fila['NotaCreditoDetalleCantidad'],1,0,'C'); //**
			 $this->SetXY(140,$ubicaf);
			 $precaux = $english_format_number = number_format($fila['NotaCreditodetallepvp'], 2, '.', '');
			 $this->Cell(20,$alto,$precaux,1,0,'R'); //** 
			 $this->SetXY(160,$ubicaf);
			 $precaux = $english_format_number = number_format($fila['Notacreditodetalledescuento'], 2, '.', '');
			 $this->Cell(20,$alto,$precaux,1,0,'R'); //**
			 $this->SetXY(180,$ubicaf);
			 $precaux = $english_format_number = number_format($fila['NotaCreditoDetalleBaseImponibl'], 2, '.', '');
			 $this->Cell(21,$alto,$precaux,1,1,'R');
			 $ubicaf = $ubicaf + $alto;
					// echo 'inserta linea';
					 //$pdf->Cell(30,5,$fila['OCCotizacionDetalleTotal'],1,0,'R'); //**
					 //$pdf->Cell(10,5,$tline,1,0,'R'); //**
				 
				 //$pdf->Cell(20,10,$fila['OCCotizacionDetalleIce2'],1,0); //**
				 //OCCotizacionDetalleSubtotal
				 //OCCotizacionDetal35Iva2
				 //$pdf->Ln(); //Hacer el salto de linea para la siguiente fila del registro
				 //$varo = $varo + $fila['cofototala'];
				// $varo1 = $english_format_number = number_format($varo, 2, '.', '');

			}
	//$varo = round($varo,2);

		}
	function fmensaje4($cn){
	  $mensaje5 = traemensaje4($cn);
	  $this->SetFont('Arial','B',9);
	  $this->Ln();
	  $this->MultiCell(190,4,utf8_decode($mensaje4),0,'J');
	}
	
	function fmensaje5($cn){
	  $mensaje5 = traemensaje5($cn);
	  $this->SetFont('Arial','B',9);
	  $this->Ln();
	  $this->MultiCell(190,4,utf8_decode($mensaje5),0,'J');
	}
	
	function fmensaje6($cn){
	  $mensaje6 = traemensaje6($cn);
	  $this->SetFont('Arial','B',9);
	  $this->Ln();
	  $this->MultiCell(190,4,utf8_decode($mensaje6),0,'J');
	}
	
	// Detalle de ND
	// 23-mayo-2018
	function detallend($factid,$cn,$crazons,$motivoanula){
		$sql = "SELECT NotaDebitoDetalleBaseImponibl,notadebitodetalleiva FROM notadebitodetalle f WHERE f.NotadebitoId = $factid";
		if (!$resultado = $cn->query($sql)) {
        		
    		echo "Lo sentimos, problemas al buscar datos de detalle ND interno pdf.";
    		exit;
        }
        

		//Ahora mediante un bucle construimos el reporte 
		//Pero primero validemos si existen alumnos en ese curso nos cargue los datos
		//$numfilas = mysql_num_rows($listado);
		
		$varo = 0;
		if (strlen(trim($crazons)) >= 56){
			$ubicaf = 150;
		} else {
			$ubicaf = 145;
		}	
		while($fila2 = $resultado->fetch_assoc()){
    		 $tline = 0;
    		 $tline = 0;
    		 $tline= round($tline,2);
    		 $totb = $fila['NotaDebitoDetalleBaseImponibl'];
    		 $toti = $fila['notadebitodetalleiva'];
    		 $totnd = $totb + $toti;
    		 //$alto = altofila($numcar);
    		 $alto = 4;
    		 $this->SetXY(10,$ubicaf);
    		 $y1 = $this->GetY();
    		 $x1 = $this->GetX(); 
    		 $this->MultiCell(130,4,utf8_encode($motivoanula),1,'l'); 
    		 $y2 = $this->GetY();
     		 $alto = $y2 - $y1 ;
    		 $this->SetXY(140,$ubicaf);
    		 $this->Cell(61,$alto,$totb,1,1,'C'); //id  
    		 //Celda con ancho de 50, alto de 10, el dato, borde 1, sin salto de linea**
    		 //$this->SetXY(125,$ubicaf);
    		 //$this->Cell(15,$alto,$totnd,1,1,'C'); //**
    		 $ubicaf = $ubicaf + $alto;
    		 //echo 'inserta linea';


		}
	}	
	
	function totales($fsubtotal,$fdescuento,$fiva,$ftotalimp,$cdireccion,$ctelefono,$cemail,$factid,$fsubtotal0){
		//$this->Cell(15,7,'',0,0,'L'); 
		$totsub = $fsubtotal - $fsubtotal0;
		if ($totsub == 0 ){
			$sub12 = 0;
			$sub0 = $fsubtotal0;
		}  elseif($totsub == $fsubtotal){
			$sub12 = $fsubtotal;
			$sub0 = 0;
		}  elseif($totsub != $fsubtotal){
			$sub12 = $fsubtotal - $fsubtotal0;
			$sub0 = $fsubtotal0;
		}	
		$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'SUBTOTAL',1,0,'l'); //Titulo del reporte
		$fsubtotal = $english_format_number = number_format($fsubtotal, 2, '.', '');
		$this->Cell(21,5,$fsubtotal,1,1,'R'); //Titulo del reporte
		
		
		
		$this->Cell(130,5,'INFORMACION ADICIONAL',0,0,'C');
		$this->Cell(40,5,'SUBTOTAL 0%',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,$fsubtotal0,1,1,'R'); //Titulo del reporte
		
		$this->Cell(128,5,'DIRECCION','TRL',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		$this->Cell(40,5,'SUBTOTAL NO SUJETO IVA',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,'0.00',1,1,'R'); //Titulo del reporte
	
		$this->Cell(128,5,$cdireccion,'RL',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'SUBTOTAL SIN IMPUESTOS',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,'0.00',1,1,'R'); //Titulo del reporte
		
		$this->Cell(128,5,$ctelefono,'RL',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'DESCUENTO',1,0,'l'); //Titulo del reporte
		$fdescuento = $english_format_number = number_format($fdescuento, 2, '.', '');
		$this->Cell(21,5,$fdescuento,1,1,'R'); //Titulo del reporte
		
		$this->Cell(128,5,'CORREO','LR',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		$this->Cell(40,5,'ICE',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,'0.00',1,1,'R'); //Titulo del reporte
		
		$this->Cell(128,5,$cemail,'RL',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'IVA',1,0,'l'); //Titulo del reporte
		$fiva = $english_format_number = number_format($fiva, 2, '.', '');
		$this->Cell(21,5,$fiva,1,1,'R'); //Titulo del reporte
		
		$this->Cell(28,5,'Referencia','BL',0,'L');
		$this->Cell(100,5,$factid,'BR',0,'L');
		$this->Cell(2,5,'',0,0,'L');
		//$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'PROPINA',1,0,'l'); //Titulo del reporte
		$this->Cell(21,5,'0.00',1,1,'R'); //Titulo del reporte
		
		$this->Cell(130,5,'',0,0,'L');
		$this->Cell(40,5,'VALOR TOTAL',1,0,'l'); //Titulo del reporte
		$ftotalimp = $english_format_number = number_format($ftotalimp, 2, '.', '');
		$this->Cell(21,5,$ftotalimp,1,1,'R'); //Titulo del reporte
	
	}
	
	
	
		
	
		
	//El metodo para crear el encabezado
	function Header()
	{
	//$orden = 3;
	    $this->SetFont('Arial','B',7); //Tipo de letra, estilo y tamaño
	    $this->Cell(0,10,'',0,1,'C'); //Titulo del reporte
	    $this->Image('logo_alfa.jpg',15,25,80,30);//punto X,Y ancho, alto//5,10,95,55
	    //$this->Cell(50,10,'No Orden de Compra: '.$orden,1,1,'C'); //Titulo del reporte
	   // $this->Cell(0,10,$gorden,0,1,'C'); //Titulo del reporte
	    
 

 
	}
 
	// Pie de página
	function Footer()
	{
		$gorden = 3;
	    // Posición: a 1,5 cm del final
	    $this->SetY(-15);
	    // Arial italic 8
	    $this->SetFont('Arial','I',8);
	    // Número de página
	 
	    $this->Cell(0,10,'Pag '.$this->PageNo().'/{nb}',0,0,'C');
		//$this->Cell(5,15,' Orden'.$gorden,1,0,'C'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    //$this->Cell(10,25,'Cantidad',1,0,'C'); //**
	    //$this->Cell(10,30,'Precio',1,0,'C'); //**
	}

	function cabecera(){
		//Encabezado de la tabla
	    $this->SetFillColor(111,159,171);
	    $this->SetFont('Arial','B',8);
	    $this->Cell(35,6,'Codigo Principal',1,0,'C','true'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(80,6,'Descripcion',1,0,'C','true'); //**
	    $this->Cell(15,6,'Cantidad',1,0,'C','true'); //**
	    $this->Cell(20,6,'Precio Unit.',1,0,'C','true'); //**
	    $this->Cell(20,6,'Descuento',1,0,'C','true'); //**
	    $this->Cell(21,6,'Precio Total',1,1,'C','true'); //**
	}
	
	
	function cabecerand(){
		//Encabezado de la tabla
	    $this->SetFillColor(111,159,171);
	    $this->SetFont('Arial','B',8);
	    $this->Cell(130,6,'RAZON DE LA MODIFICACION',1,0,'C','true'); //ancho,alto,dato,borde,salto,alineacion centrado**
	    $this->Cell(61,6,'VALOR DE LA MODIFICACION',1,1,'C','true'); //**
	    //$this->Cell(15,6,'Cantidad',1,0,'C','true'); //**
	    //$this->Cell(20,6,'Precio Unit.',1,0,'C','true'); //**
	    //$this->Cell(20,6,'Descuento',1,0,'C','true'); //**
	    //$this->Cell(21,6,'Precio Total',1,1,'C','true'); //**
	}
	
	
}


?>
